package com.bytesbee.mysinglelivechannel.fcm;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.RingtoneManager;
import android.net.Uri;
import android.text.Html;
import android.text.TextUtils;
import android.util.Patterns;

import androidx.core.app.NotificationCompat;

import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.async.BaseTask;
import com.bytesbee.mysinglelivechannel.async.TaskRunner;
import com.bytesbee.mysinglelivechannel.managers.SessionManager;
import com.bytesbee.mysinglelivechannel.utils.Utils;
import com.google.firebase.messaging.FirebaseMessaging;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link <a href="https://bytesbee.com">BytesBee</a>
 */
public class NotificationUtils {

    private final Context context;

    public NotificationUtils(Context context) {
        this.context = context;
    }

    public void showNotificationMessage(String title, String message, Intent intent) {
        showNotificationMessage(title, message, intent, null);
    }

    public void showNotificationMessage(final String title, final String message, Intent intent, String imageUrl) {
        try {
            if (TextUtils.isEmpty(message)) {
                return;
            }

            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
            final PendingIntent pendingIntent = PendingIntent.getActivity(context, 0, intent, PendingIntent.FLAG_IMMUTABLE | PendingIntent.FLAG_CANCEL_CURRENT);

            final NotificationCompat.Builder builder = new NotificationCompat.Builder(context, "MyChannel");
            builder.setDefaults(Notification.DEFAULT_LIGHTS | Notification.DEFAULT_VIBRATE);

            final Uri sound = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);

            if (!TextUtils.isEmpty(imageUrl) && (imageUrl.endsWith(".jpg") || imageUrl.endsWith(".png"))) {
                if (imageUrl.length() > 4 && Patterns.WEB_URL.matcher(imageUrl).matches()) {
                    Bitmap bitmap = Utils.getBitmapFromURL(imageUrl);
                    if (bitmap != null) {
                        showBigNotification(bitmap, builder, title, message, pendingIntent, sound);
                    } else {
                        showSmallNotification(builder, title, message, pendingIntent, sound);
                    }
                }
            } else {
                showSmallNotification(builder, title, message, pendingIntent, sound);
            }
        } catch (Exception ignored) {
        }
    }


    private void showSmallNotification(NotificationCompat.Builder builder, String title, String message, PendingIntent resultPendingIntent, Uri sound) {
        final int icon = R.mipmap.ic_launcher;

        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.addLine(message);
        Notification notification;
        notification = builder.setSmallIcon(icon).setTicker(title).setWhen(0)
                .setAutoCancel(true)
                .setContentTitle(title)
                .setContentIntent(resultPendingIntent)
                .setSound(sound)
                .setStyle(inboxStyle)
                .setSmallIcon(R.drawable.ic_notification)
                .setLargeIcon(BitmapFactory.decodeResource(context.getResources(), icon))
                .setContentText(message)
                .build();
        builder.setDefaults(Notification.DEFAULT_LIGHTS | Notification.DEFAULT_VIBRATE);

        NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        notificationManager.notify(title.hashCode(), notification);
    }

    private void showBigNotification(Bitmap bitmap, NotificationCompat.Builder builder, String title, String message, PendingIntent resultPendingIntent, Uri sound) {
        final int icon = R.mipmap.ic_launcher;

        NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
        bigPictureStyle.setBigContentTitle(context.getString(R.string.app_name));
        bigPictureStyle.setSummaryText(Html.fromHtml(message, Html.FROM_HTML_MODE_LEGACY).toString());
        bigPictureStyle.bigPicture(bitmap);
        bigPictureStyle.bigLargeIcon(bitmap);
        Notification notification;
        notification = builder.setSmallIcon(icon).setTicker(title).setWhen(0)
                .setAutoCancel(true)
                .setContentTitle(title)
                .setContentIntent(resultPendingIntent)
                .setSound(sound)
                .setStyle(bigPictureStyle)
                .setSmallIcon(R.mipmap.ic_launcher)
                .setLargeIcon(BitmapFactory.decodeResource(context.getResources(), icon))
                .setContentText(message)
                .build();
        builder.setDefaults(Notification.DEFAULT_LIGHTS | Notification.DEFAULT_VIBRATE);

        NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        notificationManager.notify(message.hashCode(), notification);
    }


    public void sendRegistrationToServer(final String token) {
        final String fcm_url = Utils.getFCMUrl(context, token);
        try {
            final URL url = new URL(fcm_url);
            HttpURLConnection httpURLConnection = (HttpURLConnection) url.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.connect();

            final int statusCode = httpURLConnection.getResponseCode();
            if (statusCode != 200) {
                Utils.sout("Error " + statusCode + " for URL " + url.toExternalForm());
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String inputLine;
            StringBuilder stringBuffer = new StringBuilder();
            while ((inputLine = bufferedReader.readLine()) != null) {
                stringBuffer.append(inputLine);
            }
            bufferedReader.close();
            SessionManager.get().setFCMToken(token);
        } catch (Exception ignored) {

        }
    }

    public void checkFCMTokenUpdated(final Activity activity) {
        try {
            FirebaseMessaging.getInstance().getToken().addOnSuccessListener(activity, newToken -> {
                if (!SessionManager.get().getFCMToken().equalsIgnoreCase(newToken)) {
                    //call API
                    uploadFCMToken(newToken);
                }
            });
        } catch (Exception ignored) {
        }
    }

    private void uploadFCMToken(final String newToken) {
        //noinspection rawtypes
        final BaseTask baseTask = new BaseTask() {
            @Override
            public void setUiForLoading() {
                super.setUiForLoading();
            }

            @Override
            public Object call() {
                try {
                    sendRegistrationToServer(newToken);
                } catch (Exception e) {
                    Utils.getErrors(e);
                }
                return null;
            }

            @Override
            public void setDataAfterLoading(Object result) {
            }

        };

        final TaskRunner runner = new TaskRunner();
        //noinspection unchecked
        runner.executeAsync(baseTask);
    }
}
